import { createRouter, defineEventHandler, useBase } from 'h3'

const router = createRouter()

router.get('/test', defineEventHandler(() => {
    const code1 =  `在Vue 3中，通过\`setup()\`函数与Composition API的结合，你可以实现更加高效和模块化的组件开发。下面提供一个综合示例，该示例展示了如何使用\`ref\`创建响应式数据、定义方法以及如何在模板中使用这些功能，同时还包括条件渲染和事件处理。\n\n**组件代码示例:**\n\n\`\`\`vue\n<template>\n  <div>\n    <!-- 显示响应式消息 -->\n    <p v-if=\"showMessage\">{{ displayedMessage }}</p>\n    \n    <!-- 按钮控制消息的显示与切换 -->\n    <button @click=\"toggleMessage\">切换消息</button>\n    <button @click=\"hideShowMessage\">隐藏/显示消息</button>\n  </div>\n</template>\n\n<script>\nimport { ref, computed } from 'vue';\n\nexport default {\n  setup() {\n    // 使用ref创建响应式数据\n    const originalMessage = ref('这是原始消息');\n    \n    // 计算属性用于展示的消息，基于原始消息动态变化\n    const displayedMessage = computed(() => {\n      if (showMessage.value) {\n        return originalMessage.value;\n      }\n      return '';\n    });\n    \n    // 控制消息显示与否的响应式数据\n    const showMessage = ref(true);\n    \n    // 切换消息的内容（假设为一种简单切换）\n    function toggleMessage() {\n      originalMessage.value = originalMessage.value === '这是原始消息' ?\n                              '现在消息已改变!' :\n                              '这是原始消息';\n    }\n\n    // 控制消息的显示与隐藏\n    function hideShowMessage() {\n      showMessage.value = !showMessage.value;\n    }\n\n    // 返回给模板的数据和方法\n    return {\n      displayedMessage,\n      toggleMessage,\n      hideShowMessage,\n      showMessage, // 如果需要在模板中直接控制显隐，可以返回\n    };\n  },\n};\n</script>\n\`\`\`\n\n在这个示例中：\n- 使用\`ref\`创建了两个响应式变量\`originalMessage\`和\`showMessage\`，分别用于存储消息内容和控制是否显示消息。\n- 利用\`computed\`创建\`displayedMessage\`来根据\`originalMessage\`和显示标志动态展现消息。\n- 定义了两个方法\`toggleMessage\`和\`hideShowMessage\`，分别用来切换消息内容和控制消息的显示与隐藏。\n- 模板中通过\`v-if\`指令和事件监听来呈现动态效果，实现了用户交互和数据反应性的完美融合，体现了Composition API的优势。`
    const code2 = `在Vue 3中，两种编写组件的方式是通过\`setup()\`函数和使用\`defineComponent\`。下面分别展示这两种方法的基本用法。\n\n### 使用 \`setup()\` 函数\n\n\`setup()\` 是Vue 3 Composition API的一部分，它提供了一个独立的作用域来设置组件的逻辑，不直接混入到模板或数据属性中。此函数不接受任何选项对象，而是直接访问setupContext的属性（如props和attrs）。\n\n\`\`\`vue\n<script>\nimport { defineComponent, ref } from 'vue';\n\nexport default defineComponent({\n  setup(props) {\n    // 定义响应式数据\n    const count = ref(0);\n\n    // 方法\n    const increment = () => {\n      count.value++;\n    };\n\n    return { count, increment };\n  },\n  template: \`\n    <button @click=\"increment\">{{ count }}</button>\n  \`,\n});\n</script>\n\`\`\`\n\n### 使用 \`defineComponent\` 结合选项API\n\n虽然\`setup()\`更偏向于Composition API，但如果你想混合使用Options API与一些Composition API特性，可以直接在其选项结构中使用\`setup()\`，或者完全使用\`defineComponent\`包裹传统的Options风格代码。\n\n\`\`\`vue\n<script>\nimport { defineComponent } from 'vue';\n\nexport default defineComponent({\n  data() {\n    return {\n      count: 0,\n    };\n  },\n  methods: {\n    increment() {\n      this.count++;\n    },\n  },\n  template: \`\n    <button @click=\"increment\">{{ count }}</button>\n  \`,\n});\n</script>\n\`\`\`\n\n在这个例子中，我们展示了如何在Vue 3中定义一个简单的组件，其中一个是使用了Composition API的\`setup()\`函数，另一个则是传统风格，通过\`data\`, \`methods\`, 和 \`template\` 属性来定义。`
    return code1 + code2
}))

export default useBase('/api/mock', router.handler)
